#!/bin/sh
if ! ${ACCPROJ}/utils/check_build_env; then
    cd ${ACCPROJ}/utils
    . ./build_env_init
    cd -
fi

#if [ ! -f ${ACCPROJ}/prom/bootloader/tools/env/fw_printenv ]; then
#    echo "${ACCPROJ}/prom/bootloader/tools/env/fw_printenv does not exist."
#    echo "Execute 'make loader' to generate"
#    exit 1
#fi

#cp -f ${ACCPROJ}/prom/bootloader/tools/env/fw_printenv  ${FS_DIR}/usr/sbin/

mkdir -p ${ACCROOTFS}/dev
mkdir -p ${ACCROOTFS}/flash
mkdir -p ${ACCROOTFS}/proc
mkdir -p ${ACCROOTFS}/root
mkdir -p ${ACCROOTFS}/sys
mkdir -p ${ACCROOTFS}/tmp
mkdir -p ${ACCROOTFS}/usr/map
mkdir -p ${ACCROOTFS}/var/log/zebos
mkdir -p ${ACCROOTFS}/var/run

cd ${ACCPROJ}/fs
echo "Create symbolic link for shared library ..."
./create_libc_so_link.sh
if [ $? -ne 0 ]; then
	echo "An error occurred while creating libc so files symbolic links"
	exit 1
fi

cd ${ACCPROJ}/fs
rm *.squashfs
cd rootfs
rm -rf dev
tar zxf ../dev.tgz
chown 0:0 dev
cd ..
./mksquashfs.sh
echo "Done"
